/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.util.zipdir;

import com.ibm.hwmca.base.util.zipdir.ZipDirPartition;
import com.ibm.hwmca.fw.util.CommonXMLParser;
import com.ibm.hwmca.fw.util.MalformedXMLException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class ZipDirXMLParser
extends CommonXMLParser
implements ErrorHandler {
    private static final String TRACE_MASKT = "XZIPXMLT";
    private static final String TRACE_MASKF = "XZIPXMLF";
    private static final String TRACE_MASKD = "XZIPXMLD";
    private static final String TAG_PARTITIONS = "zipdir-partitions";
    private static final String TAG_PARTITION = "partition";
    private static final String TAG_ROOT = "partition-root";
    private static final String TAG_DAYS_TO_KEEP = "days-to-keep";
    private static final String TAG_MAX_DIRS = "max-dirs";
    private static final String ATTRIB_NAME = "name";

    public ZipDirXMLParser() throws SAXNotRecognizedException, SAXNotSupportedException {
        Trace.trace(TRACE_MASKD, "<->ctor");
    }

    public static ZipDirPartition parseXML(String fileName, String partitionKey) throws MalformedXMLException {
        return ZipDirXMLParser.parseXML(new File(fileName), partitionKey);
    }

    public static ZipDirPartition parseXML(File file, String partitionKey) throws MalformedXMLException {
        Trace.trace(TRACE_MASKD, "parseXML(" + file + "," + partitionKey + ")");
        try {
            ZipDirXMLParser parser = new ZipDirXMLParser();
            parser.parse(new InputSource(new FileInputStream(file)));
            Document doc = parser.getDocument();
            NodeList root = doc.getElementsByTagName(TAG_PARTITIONS);
            ZipDirPartition zpd = null;
            if (root.getLength() != 1) {
                throw new MalformedXMLException("A single <zipdir-partitions> is expected.");
            }
            zpd = ZipDirXMLParser.parsePartitions(root.item(0), partitionKey);
            return zpd;
        }
        catch (IOException e) {
            throw new MalformedXMLException("IOException reading file");
        }
        catch (ClassNotFoundException e) {
            throw new MalformedXMLException("ClassNotFoundException!");
        }
        catch (SAXParseException e) {
            throw new MalformedXMLException("SaxParseException! " + CommonXMLParser.where(e));
        }
        catch (SAXException e) {
            throw new MalformedXMLException("SaxException! " + e);
        }
    }

    private static ZipDirPartition parsePartitions(Node node, String partitionKey) throws ClassNotFoundException, MalformedXMLException {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                if (child.getNodeName().toLowerCase().equals(TAG_PARTITION)) {
                    Node name = child.getAttributes().getNamedItem(ATTRIB_NAME);
                    if (name == null || name.getNodeType() != 2) {
                        throw new MalformedXMLException("Unable to locate name attribute on <partition> entry");
                    }
                    if (name.getNodeValue().equals(partitionKey)) {
                        return ZipDirXMLParser.parsePartition(child, partitionKey);
                    }
                } else {
                    throw new MalformedXMLException("Unknown tag <" + child.getNodeName().toLowerCase() + ">");
                }
            }
            ++i;
        }
        return null;
    }

    private static ZipDirPartition parsePartition(Node node, String partitionKey) throws ClassNotFoundException, MalformedXMLException {
        ZipDirPartition zpd = new ZipDirPartition(partitionKey);
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                if (child.getNodeName().toLowerCase().equals(TAG_ROOT)) {
                    zpd.setRoot(CommonXMLParser.gatherTextContents(child));
                } else if (child.getNodeName().toLowerCase().equals(TAG_DAYS_TO_KEEP)) {
                    zpd.setDaysToKeep(Integer.parseInt(CommonXMLParser.gatherTextContents(child)));
                } else if (child.getNodeName().toLowerCase().equals(TAG_MAX_DIRS)) {
                    zpd.setMaxDirs(Integer.parseInt(CommonXMLParser.gatherTextContents(child)));
                } else {
                    throw new MalformedXMLException("Unknown tag <" + child.getNodeName().toLowerCase() + ">");
                }
            }
            ++i;
        }
        Trace.trace(TRACE_MASKD, "parsePartition:" + zpd);
        return zpd;
    }
}

